/*
 * Decompiled with CFR 0.152.
 */
package jtbcore.container;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ContainerBean {
    protected Boolean autoStart = false;
    protected String name;
    protected String clazz;
    protected String objectFactory;
    protected BeanConstructor constructor = new BeanConstructor();
    protected List<InitFunction> initFunctions = new ArrayList<InitFunction>();
    protected Map<String, Property> properties = new ConcurrentHashMap<String, Property>();

    public Boolean isAutoStart() {
        return this.autoStart;
    }

    public void setAutoStart(Boolean autoStart) {
        this.autoStart = autoStart;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getClazz() {
        return this.clazz;
    }

    public void setClazz(String clazz) {
        this.clazz = clazz;
    }

    public String getObjectFactory() {
        return this.objectFactory;
    }

    public void setObjectFactory(String f) {
        this.objectFactory = f;
    }

    public boolean hasObjectFactory() {
        return this.objectFactory != null;
    }

    public List<InitFunction> getInitFunctions() {
        return this.initFunctions;
    }

    public void addInitFunctions(InitFunction func) {
        this.initFunctions.add(func);
    }

    public void addConstructorProperty(Property prop) {
        this.constructor.addProperty(prop);
    }

    public Constructor lookupConstructor(Class clazz) {
        Constructor<?>[] cs;
        Constructor<?>[] constructorArray = cs = clazz.getConstructors();
        int n = cs.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> c = constructorArray[n2];
            if (c.getParameterCount() == this.constructor.getPropertyCount().intValue()) {
                int paramsTypeMatch = 0;
                Parameter[] params = c.getParameters();
                int x = 0;
                while (x < params.length) {
                    if (params[x].getType() == this.constructor.getProperty(x).typeToClass()) {
                        ++paramsTypeMatch;
                    }
                    ++x;
                }
                if (paramsTypeMatch == c.getParameterCount()) {
                    return c;
                }
            }
            ++n2;
        }
        return null;
    }

    public Map<String, Property> getSettings() {
        return this.properties;
    }

    public void setSettings(Map<String, Property> properties) {
        this.properties = properties;
    }

    public void setSetting(String key, Property prop) {
        if (this.properties.containsKey(key)) {
            System.err.println("Warning, overwriting property: " + key);
        }
        this.properties.put(key, prop);
    }

    public static class BeanConstructor {
        protected List<Property> properties = new ArrayList<Property>();

        public Property getProperty(int no) {
            return this.properties.get(no);
        }

        public List<Property> getProperties() {
            return this.properties;
        }

        public void addProperty(Property prop) {
            this.properties.add(prop);
        }

        public Integer getPropertyCount() {
            return this.properties.size();
        }

        public Object[] asParams() {
            Object[] params = new Object[this.properties.size()];
            int x = 0;
            while (x < this.properties.size()) {
                params[0] = this.getProperty(x).getValue();
                ++x;
            }
            return params;
        }
    }

    public static class InitFunction {
        protected List<Property> properties = new ArrayList<Property>();
        protected String functionName;

        public InitFunction(String functionName) {
            this.functionName = functionName;
        }

        public String getFunctionName() {
            return this.functionName;
        }

        public void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        public Property getProperty(int no) {
            return this.properties.get(no);
        }

        public List<Property> getProperties() {
            return this.properties;
        }

        public void addProperty(Property prop) {
            this.properties.add(prop);
        }

        public Integer getPropertyCount() {
            return this.properties.size();
        }

        public Object[] asParams() {
            Object[] params = new Object[this.properties.size()];
            int x = 0;
            while (x < this.properties.size()) {
                params[0] = this.getProperty(x).getValue();
                ++x;
            }
            return params;
        }

        public Method lookupFunction(Class clazz) {
            Method[] methods;
            Method[] methodArray = methods = clazz.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method m = methodArray[n2];
                if (m.getParameterCount() == this.getPropertyCount().intValue() && this.functionName.equals(m.getName())) {
                    int paramsTypeMatch = 0;
                    Parameter[] params = m.getParameters();
                    int x = 0;
                    while (x < params.length) {
                        if (params[x].getType() == this.getProperty(x).typeToClass()) {
                            ++paramsTypeMatch;
                        }
                        ++x;
                    }
                    if (paramsTypeMatch == m.getParameterCount()) {
                        return m;
                    }
                }
                ++n2;
            }
            return null;
        }
    }

    public static class Property {
        protected String name;
        protected String type;
        protected String value;
        protected String ref;
        protected List<String> stringlist;

        public Class typeToClass() {
            if ("int".equals(this.type)) {
                return Integer.class;
            }
            if ("integer".equals(this.type)) {
                return Integer.class;
            }
            if ("long".equals(this.type)) {
                return Long.class;
            }
            if ("float".equals(this.type)) {
                return Float.class;
            }
            if ("double".equals(this.type)) {
                return Double.class;
            }
            if ("string".equals(this.type)) {
                return String.class;
            }
            try {
                return Class.forName(this.type);
            }
            catch (Exception exception) {
                return null;
            }
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getRef() {
            return this.ref;
        }

        public void setRef(String ref) {
            this.ref = ref;
        }

        public List<String> getStringlist() {
            return this.stringlist;
        }

        public void setStringlist(List<String> stringlist) {
            this.stringlist = stringlist;
        }
    }
}

